/*
 *  KernelEx
 *  Copyright (C) 2008, Xeno86
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _SHELL32_APILIST_H
#define _SHELL32_APILIST_H

#include "kexcoresdk.h"

BOOL init_shell32();
extern const apilib_api_table apitable_shell32;

/*** AUTOGENERATED APILIST DECLARATIONS BEGIN ***/

// shell32\CommandLineToArgvW.c
LPWSTR* WINAPI CommandLineToArgvW_new(LPCWSTR lpCmdline, int* numargs);

// shell32\IsUserAnAdmin.c
BOOL WINAPI IsUserAnAdmin_new(void);

// shell32\SHGetImageList.c

// shell32\_shell32_apilist.c

// shell32\_shell32_stubs.c
STUB SHCreateShellItem_stub;
STUB SHOpenFolderAndSelectItems_stub;
STUB PathCleanupSpec_stub;
STUB SHCloneSpecialIDList_stub;
STUB SHCoCreateInstance_stub;
STUB SHDefExtractIconW_stub;
STUB SHEnumerateUnreadMailAccountsW_stub;
STUB SHFindFiles_stub;
STUB SHGetIconOverlayIndexW_stub;
STUB SHGetKnownFolderPath_stub;
STUB SHPathPrepareForWriteW_stub;
STUB SHRestricted_stub;
STUB SHSetLocalizedName_stub;
STUB SHSetUnreadMailCountW_stub;
STUB SHCreateItemFromParsingName_stub;
STUB SHExtractIconsW_stub;
STUB SHGetImageList_stub;
STUB SHLimitInputEdit_stub;
STUB SHOpenWithDialog_stub;
STUB SHPropStgCreate_stub;
STUB SHPropStgReadMultiple_stub;
STUB SHPropStgWriteMultiple_stub;
STUB SHQueryUserNotificationState_stub;
STUB Shell_NotifyIconGetRect_stub;
STUB ILAppendID_stub;
STUB ILClone_stub;
STUB ILCloneFirst_stub;
STUB ILCombine_stub;
STUB ILCreateFromPathW_stub;
STUB ILFindChild_stub;
STUB ILFindLastID_stub;
STUB ILFree_stub;
STUB ILGetNext_stub;
STUB ILGetSize_stub;
STUB ILIsEqual_stub;
STUB ILIsParent_stub;
STUB ILLoadFromStream_stub;
STUB ILRemoveLastID_stub;
STUB ILSaveToStream_stub;
/*** AUTOGENERATED APILIST DECLARATIONS END ***/

#endif
